# Define all of E6 the orbit functions
E6Orbits:= rec (
  A1      := rec( orbit:=E6_A1,      p:= [5,7,11,13], name:="E6 A1"),
  2A1     := rec( orbit:=E6_2A1,     p:= [5,7,11,13], name:="E6 2A1"),
  3A1     := rec( orbit:=E6_3A1,     p:= [5,7,11,13], name:="E6 3A1"),
  A2      := rec( orbit:=E6_A2,      p:= [5,7,11,13], name:="E6 A2"),
  A2A1    := rec( orbit:=E6_A2A1,    p:= [5,7,11,13], name:="E6 A2A1"),
  2A2     := rec( orbit:=E6_2A2,     p:= [5,7,11,13], name:="E6 2A2"),
  A22A1   := rec( orbit:=E6_A22A1,   p:= [5,7,11,13], name:="E6 A22A1"),
  A3      := rec( orbit:=E6_A3,      p:= [5,7,11,13], name:="E6 A3"),
  2A2A1   := rec( orbit:=E6_2A2A1,   p:= [5,7,11,13], name:="E6 2A2A1"),
  A3A1    := rec( orbit:=E6_A3A1,    p:= [5,7,11,13], name:="E6 A3A1"),
  D4a1    := rec( orbit:=E6_D4a1,    p:= [5,7,11,13], name:="E6 D4a1"),
  A4      := rec( orbit:=E6_A4,      p:= [5,7,11,13], name:="E6 A4"),
  D4      := rec( orbit:=E6_D4,      p:= [  7,11,13], name:="E6 D4"),
  A4A1    := rec( orbit:=E6_A4A1,    p:= [5,7,11,13], name:="E6 A4A1"),
  A5      := rec( orbit:=E6_A5,      p:= [  7,11,13], name:="E6 A5"),
  D5a1    := rec( orbit:=E6_D5a1,    p:= [  7,11,13], name:="E6 D5a1"),
  E6a3    := rec( orbit:=E6_E6a3,    p:= [  7,11,13], name:="E6 E6a3"),
  D5      := rec( orbit:=E6_D5,      p:= [    11,13], name:="E6 D5"),
  D5Trans := rec( orbit:=E6_D5Trans, p:= [    11   ], name:="E6 D5 Trans"),
  E6a1    := rec( orbit:=E6_E6a1,    p:= [    11,13], name:="E6 E6a1"),
  E6      := rec( orbit:=E6_E6,      p:= [       13], name:="E6 E6")
);

# Define all of F4 the orbit functions
F4Orbits:= rec(
  A1        := rec( orbit:=F4_A1,        p:= [5,7,11,13], name:="F4 A1"),
  A1tilde   := rec( orbit:=F4_A1tilde,   p:= [5,7,11,13], name:="F4 A1tilde"),
  A1A1tilde := rec( orbit:=F4_A1A1tilde, p:= [5,7,11,13], name:="F4 A1A1tilde"),
  A2        := rec( orbit:=F4_A2,        p:= [5,7,11,13], name:="F4 A2"),
  A2tilde   := rec( orbit:=F4_A2tilde,   p:= [5,7,11,13], name:="F4 A2tilde"),
  A2A1tilde := rec( orbit:=F4_A2A1tilde, p:= [5,7,11,13], name:="F4 A2A1tilde"),
  B2        := rec( orbit:=F4_B2,        p:= [5,7,11,13], name:="F4 B2"),
  A2tildeA1 := rec( orbit:=F4_A2tildeA1, p:= [5,7,11,13], name:="F4 A2tildeA1"),
  C3a1      := rec( orbit:=F4_C3a1,      p:= [5,7,11,13], name:="F4 C3a1"),
  F4a3      := rec( orbit:=F4_F4a3,      p:= [5,7,11,13], name:="F4 F4a3"),
  B3        := rec( orbit:=F4_B3,        p:= [  7,11,13], name:="F4 B3"),
  C3        := rec( orbit:=F4_C3,        p:= [  7,11,13], name:="F4 C3"),
  F4a2      := rec( orbit:=F4_F4a2,      p:= [    11,13], name:="F4 F4a2"),
  F4a1      := rec( orbit:=F4_F4a1,      p:= [    11,13], name:="F4 F4a1"),
  F4        := rec( orbit:=F4_F4,        p:= [       13], name:="F4 F4")
);

# Define all of G2 the orbit functions
G2Orbits:= rec(
  A1      := rec( orbit:=G2_A1,      p:= [5  ], name:="G2 A1"),
  A1tilde := rec( orbit:=G2_A1tilde, p:= [5  ], name:="G2 A1tilde"),
  G2      := rec( orbit:=G2_G2,      p:= [  7], name:="G2 G2"),
  G2a1    := rec( orbit:=G2_G2a1,    p:= [5  ], name:="G2 G2a1"),
);

# For representative e of nilpotent orbit gives conditions for g^e intersect N1 for
# all valid characteristic p. Output the result to a file in the specified directory
ConditionsForGEIntersectN1:=function(orbit, directory)
  local p, m, orbitInP, currName, currSolutions, filename, i, rememberingFactorsFunction;
  filename:= Filename(directory, orbit.name);
  PrintTo (filename, orbit.name); # create a single output file
  
  for p in orbit.p do    
    Exec( "time/t" ); # Print the time, this only works on windows
    
    orbitInP := orbit.orbit(p); # Obtain orbit in characteristic p
    AppendTo (filename, "\n-------------- p = ", String(p), " -------------\n");  # Split in to distinguish between p values
    Print("  ", orbit.name, " - p = ", p, "\n");
    for m in RecNames( orbitInP ) do
      Print("    ", m, "\n");

      currSolutions := FindUniqueFactorizedSolutionsOfPolynomialsInMInCharP(orbitInP.(m)^p, p);
      # Factorize the polynomials
      AppendTo (filename, "\n", m, " -> ", currSolutions, "\n"); 
    od;
  od;
end;

# Finds conditions for g e intersect N1 for all nilpotent orbits in lieAlgebra
# Output the results to the specified directory
ConditionsGEIntersectsN1ForLieAlgebra:=function(lieAlgebra, directory)
  local i;
  for i in RecNames(lieAlgebra) do 
    ConditionsForGEIntersectN1(lieAlgebra.(i), directory);
  od;
end;

# Runs ConditionsGEIntersectsN1ForLieAlgebra for E6, F4 and G2 Output the
# results to the specified directory. An example call would be -
#   ConditionsGEIntersectsN1ForE6AndF4AndG2(Directory("e:/output"));
ConditionsGEIntersectsN1ForE6AndF4AndG2:=function(directory)
  local i;
  for i in [E6Orbits,F4Orbits,G2Orbits] do
    ConditionsGEIntersectsN1ForLieAlgebra(i, directory);
  od;
end;