# Determine if the passed in polyonomial is a univariate monomial. Do this by
# checking that the polynomial: 
# - is not 0
# - is A univariate polynomial
# - Has a single Coefficient which is not zero
IsUnivariateMonomial:=function(p)
  return 
    not IsZero(p) 
    and IsUnivariatePolynomial(p) 
    and Length(Filtered(CoefficientsOfUnivariatePolynomial(p), x-> not IsZero(x))) = 1;
end;

# Determine if the passed in monomial univariate and is linear. We do this by
# checking if the 2nd coefficient is not zero.
IsUnivariateMonomialLinear:=function(m)
  return IsUnivariatePolynomial(m) and not IsZero(CoefficientsOfUnivariatePolynomial(m)[2]);
end;

# Generate a list of mononials of the polynomial. These are returned in 
# Monomial Lex Orderning
MonomialsOfPolynomial:=function(p)
  local monomials, ord, leadingTerm;
  ord := MonomialLexOrdering();
  monomials := [];
  while not IsZero(p) do
    leadingTerm := LeadingTermOfPolynomial(p, ord);
    Add(monomials, leadingTerm);
    p:=p-leadingTerm;
  od;
  return monomials;
end;

# Given the indeterminate i, check to see if it is contained inside the monomial
# Such that:
#   IsIndeterminateContainedInMonomial(y, x^2*y) = true
#   IsIndeterminateContainedInMonomial(y, x^2) = false
#
IsIndeterminateContainedInMonomial:=function(i, m)
  return Length(PolynomialCoefficientsOfPolynomial(m, i)) > 1;
end;