# This file should be read with ReadAsFunction('e:/gap/lib/F4/roots.gi')
local R, LF4, RF4, CF4, BF4, J, V26;

R:=Rationals;

LF4 := SimpleLieAlgebra("F",4,R);
RF4 := RootSystem(LF4);
CF4 := CartanMatrix(RF4);
BF4 := ChevalleyBasis(LF4);

J:=[[0,0,0,1],[1,0,0,0],[0,0,1,0],[0,1,0,0]];

V26:=HighestWeightModule(LF4,[1,0,0,0]);

return rec(
  e := function(v)
    return BF4[1][Position(PositiveRoots(RF4),TransposedMat(CF4)*(J*v))];
  end,

  f := function(v)
    return BF4[2][Position(PositiveRoots(RF4),TransposedMat(CF4)*(J*v))];
  end,

  h := function(i)
    if i=1 then return BF4[3][2];
    elif i=2 then return BF4[3][4];
    elif i=3 then return BF4[3][3];
    elif i=4 then return BF4[3][1];
    fi;
  end,

  B26:=Basis(V26)
);