# Filter a given list of any integer multiples contained with in that
# list up to p - 1. This can be useful for reducing the amount of factorizations that
# have to be done.
MultipleFreeList := function(list, p)
  local multipleFree,i;
  multipleFree := [];
  for i in list do
    if not ForAny([1..p-1] * i, x-> x in multipleFree) then
       Add(multipleFree, i);
    fi;
  od;
  return multipleFree;
end;