# This file should be read with ReadAsFunction('e:/gap/lib/G2/roots.gi')
local R, LG2, RG2, CG2, BG2, V;

R:=Rationals;
LG2:=SimpleLieAlgebra("G",2,R);
RG2:=RootSystem(LG2);
CG2:=CartanMatrix(RG2);
BG2:=ChevalleyBasis(LG2);

V:=HighestWeightModule(LG2,[1,0]);

return rec(
  e:=function(v)
    return BG2[1][Position(PositiveRoots(RG2),TransposedMat(CG2)*v)];
  end,

  f:=function(v)
    return BG2[2][Position(PositiveRoots(RG2),TransposedMat(CG2)*v)];
  end,

  h:= function(i)
    if i=1 then return BG2[3][1];
      elif i=2 then return BG2[3][2];
    fi;
  end,

  B:=Basis(V)
);