E6_D5Trans := function(charP) 
  local E6Roots,e,f,h,B27,R,h1,e0,e1,f0,v2,v3,v5,v6,v7,v8,v9,H1,F0,
        E0,E1,V2,V3,V5,V6,V7,V8,V9,u1,u2,u3,u4,u5,w1,w2,w3,w4,w5,z2,
        z3,z4,z5,z6,z7,z8,z9,A,B,C,D,F,G,I,N,K,L;
        
  E6Roots := ReadAsFunction("e:/gap/lib/E6/roots.gi")();
  e := E6Roots.e; f := E6Roots.f; h := E6Roots.h; B27 := E6Roots.B27;

  h1:=2*h(1)+3*h(2)+4*h(3)+6*h(4)+5*h(5)+4*h(6);
  e0:=e([1,0,0,0,0,0])+e([0,0,1,0,0,0])+e([0,0,0,1,0,0])+e([0,1,0,0,0,0])+e([0,0,0,0,1,0]);
  e1:=e([1,0,1,1,0,0]);
  f0:=8*f([1,0,0,0,0,0])+14*f([0,0,1,0,0,0])+18*f([0,0,0,1,0,0])+10*f([0,0,0,0,1,0])+10*f([0,1,0,0,0,0]);

  v2:=f([0,0,1,1,1,1])-f([0,1,0,1,1,1]);
  v3:=e([1,1,2,2,1,1])+e([1,1,1,2,2,1]);
  v5:=e([1,0,1,1,1,0])+e([1,1,1,1,0,0]);
  v6:=f([0,0,0,0,0,1]);
  v7:=e([1,2,2,3,2,1]);
  v8:=e([1,1,1,1,1,0])+e([0,1,1,2,1,0]);
  v9:=e([1,1,2,2,1,0]);

  H1:=MatrixOfAction(B27,h1);
  F0:=MatrixOfAction(B27,f0);
  E0:=MatrixOfAction(B27,e0);
  E1:=MatrixOfAction(B27,e1);

  V2:=MatrixOfAction(B27,v2);
  V3:=MatrixOfAction(B27,v3);
  V5:=MatrixOfAction(B27,v5);
  V6:=MatrixOfAction(B27,v6);
  V7:=MatrixOfAction(B27,v7);
  V8:=MatrixOfAction(B27,v8);
  V9:=MatrixOfAction(B27,v9);

  #Basis of g(8)
  u1:=v5;
  u2:=f0*v6;
  u3:=f0*v8;
  u4:=f0*v7;
  u5:=(f0*(f0*(f0*v9)))/6;

  #basis of g(6)
  w1:=-(f0*u1)/8;
  w2:=(f0*u2)/180;
  w3:=(f0*u3)/20;
  w4:=(f0*u4)/180;
  w5:=(f0*u5)/336;

  #basis for g^{f0} not including h and fo
  z2:=5*f([1,1,2,2,1,1])+2*f([1,1,1,2,2,1]);
  z3:=2*e([0,0,1,1,1,1])-5*e([0,1,0,1,1,1]);
  z4:=6*f([0,1,1,1,0,0])+5*f([0,0,1,1,1,0])+4*f([1,0,1,1,0,0])-4*f([0,1,0,1,1,0]);
  z5:=f([1,0,1,1,1,0])+f([1,1,1,1,0,0]);
  z6:=f([1,2,2,3,2,1]);
  z7:=e([0,0,0,0,0,1]);
  z8:=3*f([1,1,1,1,1,0])+4*f([0,1,1,2,1,0]);
  z9:=f([1,1,2,2,1,0]);
	
  R:=GF(charP);

  A:=X(R,"A"); B:=X(R,"B"); C:=X(R,"C"); D:=X(R,"D"); F:=X(R,"F");
  G:=X(R,"G"); I:=X(R,"I"); N:=X(R,"N"); K:=X(R,"K"); L:=X(R,"L");

  #L:=4*A^2*C*D;
  #N:=0;
  #I:=0;
  #K:=0;
  #F:=0;
  B:=A^2;
  G:=2*A^5-A*F;

  #s:=X(S,"s"); t:=X(S,"t");
  
  #M1:=F0+s*t*H+s^2*t^2*E0+s^6*V2+t^6*V3+2*s^5*t^5*V5+4*s^8*t^8*V9;
	
  return rec(
    M:=F0+A*H1+B*E0+C*V2+D*V3+F*E1+G*V5+I*V6+N*V7+K*V8+L*V9
  );
end;