# Find 0 Indeterminate for a polynomial
gap> a:= X(Rationals, "a");;
gap> FindIndeterminatesWhichEqualZero(3*a^2);
[ a, 0 ]

# Check that value returned from FindIndeterminatesWhichEqualZero is polynomial
gap> a:= X(Rationals, "a");;
gap> value:=FindIndeterminatesWhichEqualZero(a^2)[2];;
gap> IsPolynomial(value);
true

# Look for zero indeterminate where a can't equal 0
gap> a:= X(Rationals, "a");;
gap> FindIndeterminatesWhichEqualZero(a^2 + a);
false

# Look for zero indeterminate where a can't equal 0
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> FindIndeterminatesWhichEqualZero(a*b);
false

# Fail to find lone indeterminate contained in an other monomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> FindIndeterminatesInTermsOfOtherIndeterminates(c+2*a*c+b*a);
false

# Fail to find interminate with no linear monomials
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> FindIndeterminatesInTermsOfOtherIndeterminates(2*a^2+b*c);
false

# Find polynomial in terms of c
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> FindIndeterminatesInTermsOfOtherIndeterminates(a*b+2*c+a^2);
[ c, -1/2*a^2-1/2*a*b ]

# Fail to find highest common univariate monomial in irreducable polynomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> FindHighestCommonUnivariateFactorOfPolynomial(a-b);
false

# Find highest common univariate monomial from polynomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> FindHighestCommonUnivariateFactorOfPolynomial(a*c + b*c);
rec( factors := [ c, a+b ] )

# Fail to find factor in irreducable polynomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> FindFactorsOfPolynomial(a-b);
false

# Finds factors non-irreducable polynomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> FindFactorsOfPolynomial(a^2 - b^2);
rec( factors := [ a-b, a+b ] )

# Try to find factors monomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> FindFactorsOfMonomial(a*b);
rec( factors := [ b, a ] )

# Try to find factors of a polynomial with FindFactorsOfMonomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> FindFactorsOfMonomial(a^2 + b^2);
false

# Check that substitution can be applied to polynomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> ApplySubstitution(a*b+c^2, [b,0]);
c^2

# Check that zero polynomial can still be applied
gap> a:= X(Rationals, "a");;
gap> ApplySubstitution(0, [a,0]);
0

# Find substition for indeterminate in second polynomial and substitute 
# into first
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> SubstituteIndeterminates([2*c^2, 2*a^2+b*c]);
[ rec( polynomials := [ 0, 0 ], substitutions := [ [ c, 0 ], [ a, 0 ] ] ) ]

# 2 irreducable polynomials where no substitutes can be found
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> SubstituteIndeterminates([b^2+c^3, a^3+c^2]);
[ rec( polynomials := [ c^3+b^2, a^3+c^2 ], substitutions := [  ] ) ]

# Two seperate factors which lead to different substitutions
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> d:= X(Rationals, "d");;
gap> SubstituteIndeterminates([a^2-b^2, a*c + d^2]);
[ rec( polynomials := [ 0, b*c+d^2 ], substitutions := [ [ a, b ] ] ),
  rec( polynomials := [ 0, -b*c+d^2 ], substitutions := [ [ a, -b ] ] ) ]

# Check that substitution can start off from second polynomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> c:= X(Rationals, "c");;
gap> SubstituteIndeterminatesWithKnowledge([a-b, b-c], [], 2);
[ rec( polynomials := [ 0, 0 ], substitutions := [ [ b, c ], [ a, c ] ] ) ]
