# Check that 3a^3 is a univarate monomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> IsUnivariateMonomial(3*a^3);
true

# Check that ab is not a univariate monomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> IsUnivariateMonomial(a*b);
false

# Check that a^2 + a is not univariate monomial
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> IsUnivariateMonomial(a^2+a);
false

# Check that 2a is a univariate monomial linear
gap> a:= X(Rationals, "a");;
gap> IsUnivariateMonomialLinear(2*a);
true

# Check that a^2 is not a univariate monomial linear
gap> a:= X(Rationals, "a");;
gap> IsUnivariateMonomialLinear(a^2);
false

# Get the monomials of 3a^2 + b
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> MonomialsOfPolynomial(3*a^2 + b);
[ 3*a^2, b ]

# Get the monomials of 2a^2 + a
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> MonomialsOfPolynomial(2*a^2 + a);
[ 2*a^2, a ]

# Get the monomials of 0
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> MonomialsOfPolynomial(0);
[  ]

# Check if a is contained in b^2*a
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> IsIndeterminateContainedInMonomial(a, b^2*a);
true

# Check if a is contained in b^2
gap> a:= X(Rationals, "a");;
gap> b:= X(Rationals, "b");;
gap> IsIndeterminateContainedInMonomial(a, b^2);
false
