# Given a matrix M (assumed to be over field GF(P) already), produce a list of
# solutions of unique polynomials in M. Unique up to multiples of p in 
# charateristic p.
#
# N.B. If Matrix is defined over R then let
#
#      M := Matrix*One(GF(p))
#
FindUniqueSolutionsOfPolynomialsInMInCharP := function(M, p)
  return DuplicateFreeList(SubstituteIndeterminates(MultipleFreeList(Flat(M),p)));
end;

# Given a list of solutions (such as those returned by SubstituteIndeterminates) 
# factorize each of the polynomials in each of the solutions.
FactorizeUniqueSolutionPolynomials := function(solutions)
  local i;
  for i in solutions do
    i.polynomials := List(i.polynomials, Factors);
  od;        
  return solutions;  
end;

# Same as FindUniqueSolutionsOfPolynomialsInMInCharP, however this function
# will factorize the given solutions.
FindUniqueFactorizedSolutionsOfPolynomialsInMInCharP := function(M, p)
  return FactorizeUniqueSolutionPolynomials(FindUniqueSolutionsOfPolynomialsInMInCharP(M, p));
end;