# This file should be read with ReadAsFunction('e:/gap/lib/E6/roots.gi')
local R, LE6, RE6, CE6, BE6, J, V27;

R:=Rationals;

LE6 := SimpleLieAlgebra("E",6,R);
RE6 := RootSystem(LE6);
CE6 := CartanMatrix(RE6);
BE6 := ChevalleyBasis(LE6);

V27:=HighestWeightModule(LE6,[0,0,0,0,0,1]);

return rec(
  e := function(v)
    return BE6[1][Position(PositiveRoots(RE6),TransposedMat(CE6)*(v))];
  end,

  f := function(v)
    return BE6[2][Position(PositiveRoots(RE6),TransposedMat(CE6)*(v))];
  end,

  h := function(i)
    if i=1 then return BE6[3][1];
    elif i=2 then return BE6[3][2];
    elif i=3 then return BE6[3][3];
    elif i=4 then return BE6[3][4];
    elif i=5 then return BE6[3][5];
    elif i=6 then return BE6[3][6];
    fi;
  end,

  B27:=Basis(V27)
);