#include "header.h"

/* This function uses a bisection search to find the critical value at decision analysis k matching
 * reversal probabilities under theta=0.*/


void symmetry(double *bdecision, double *bdupper, double *bdlower, double *observed, double *recruited, int k){
  double y=0.0, z=0.0, fy=0.0, fz=0.0, grad=0.0, mp=0, fmp=0;

  
  /* *******************************************************************************
   * bdecision = critical values at decision analyses
   * bdupper   = upper boundaries of the stopping rule at interim analyses
   * bdlower   = lower boundaries of the stopping at interim analyses 
   * observed  = observed number of responses at interim analyses
   * recruited = number of subjects recruited at interim analyses
   * k         = current stage of test.    
   *********************************************************************************/


  y = -20;
  z = 20;
  bdecision[k] = y;
  /* Calculate P(l1<Z1<u1, .., Zk< lk, Z'k >ck;theta=0) - P(l1<Z1<u1, .., Zk> uk, Z'k <ck;theta=0).*/
  fy =  reversal2(bdecision, bdupper, bdlower, observed, recruited, k,0.0) - reversal1(bdecision, bdupper, bdlower, observed, recruited, k, 0.0);
  
  bdecision[k] = z;
  fz =  reversal2(bdecision, bdupper, bdlower, observed, recruited, k,0.0) - reversal1(bdecision, bdupper, bdlower, observed, recruited, k,0.0);
  
  while( (z-y) >tol){
    mp = (y+z)/2.0;
    bdecision[k] = mp;
    fmp = reversal2(bdecision, bdupper, bdlower, observed, recruited, k, 0.0) - reversal1(bdecision, bdupper, bdlower, observed, recruited, k, 0.0);
    if(fmp*fy >0){
      y=mp;
      fy = fmp;
    }
    else{
      z=mp;
    }  
  } 
  
  /* Linear interpolation to find a more accurate estimate of bdupper[k] */
  bdecision[k] = y;
  fy = reversal2(bdecision, bdupper, bdlower, observed, recruited, k, 0.0) - reversal1(bdecision, bdupper, bdlower, observed, recruited, k, 0.0);
  bdecision[k] = z;
  fz = reversal2(bdecision, bdupper, bdlower, observed, recruited, k, 0.0) - reversal1(bdecision, bdupper, bdlower, observed, recruited, k, 0.0); 
  
  grad = (fz - fy)/(z-y);
  bdecision[k] = y + (-fy/grad);
  
}
