#include "header.h"

/* *********************************************************************
 * This function calculates
 * P(l1<Z1<u1,..,l(k-1)<Z(k-1)<u(k-1), Zk > uk, Z'k < ck;theta=0).
 *
 * The routine assumes boundaries of Delayed Response GST are calculated on the standardised
 * test statistic scale.
 * *********************************************************************/



double reversal2(double *bdecision, double *bdupper, double *bdlower, double *observed, double *recruited, int k, double theta){
  double inf1=0.0,inf2=0.0,mu=0.0,diff=0.0, reversalprob =0.0;
  double x[n1]={0}, xgrid[n1]={0}, w1[n2]={0}, w2[n2]={0};
  double h1[n2]={0}, h2[n2]={0}, z1[n2]={0}, z2[n2]={0};
  int i=0, j=0,mesh=0, mesh1=0, index1=0, index2=0 , m1=0, m2=0, ifail=0, s=0,i1=0, i2=0;
  char tail = 'L'; 
  
 
  /* *******************************************************************************
   * bdecision = critical values defining decision analyses 
   * bdupper   = upper boundaries of the stopping rule at interim analyses
   * bdlower   = lower boundaries of the stopping at interim analyses  
   * observed  = observed number of responses at interim analyses
   * recruited = number of subjects recruited at interim analyses
   * k         = stage of delayed response GST
   * theta     = value of unknown parameter     
   * *******************************************************************************/
 
  m1=1;
  h1[1]=1.0;
  inf1=0.0;
  
  if(k==1){ 
    inf1 = observed[1]/pow(2*sigma,2);
    inf2 = recruited[1]/pow(2*sigma,2);
    /* Create mesh efficient for integrating marginal denisty of Z1. */
   mesh = 6.0*r -1;
   for(i=1;i <= mesh;i++){
     if(i<= (r-1)){
       x[i] =(theta)*sqrt(inf1) -3.0 - 4.0*log(r/i);
     }
     else if(i >= r && i <= 5*r){
       x[i] =(theta)*sqrt(inf1) -3.0 +3.0*(i-r)/(2.0*r);
     }
     else{
       x[i]= (theta)*sqrt(inf1) + 3.0 + 4.0*log(r/(6.0*r - i));
     }
   }
  
   /* Need mesh for integrating Z1 from (bdupper[1], +infty).*/
   if(bdupper[1] >= x[mesh]){
     printf("Mesh for Z1 in reversal2.c with theta=%lf does not cover u_1 \n", theta);
     printf("Run program again with increased mesh parameter r \n");
     x[mesh-1] = bdupper[1];
     x[mesh] = bdupper[1]+0.1;
     index1 = mesh-1;
   }
   else if(bdupper[1] <= x[1]){
     index1 = 1;
   }
   else{
     for(i =1;i<= mesh;i++){
       if(x[i] <= bdupper[1]){
	 index1 = i;
       }
       if(x[i] <= bdupper[1] && i < mesh){
	 x[i] = bdupper[1];
       }
     }
   }
   
   mesh1 = mesh - index1 +1;
   for(i=1;i<= mesh1;i++){
     xgrid[i] = x[i + index1 -1];
   }
   m1 = 2*mesh1 -1;
   for(i=1;i <= m1; i++){
     j = (i+1)/2;
     z1[i] = xgrid[j];
   }   
   for(i=2; i <= m1-1; i= i+2){
     z1[i] = (z1[i-1] + z1[i+1])/2.0;
   }

   /* Calculate Simpsons rule weightings. */
   w1[1] = (1.0/6.0)*(z1[3] - z1[1]); 
   w1[m1] = (1.0/6.0)*(z1[m1] - z1[m1-2]);
   for(i=2;i <= m1-1;i=i+2){
     w1[i] = (4.0/6.0)*(z1[i+1] - z1[i-1]);
   }
   for(i=3;i <= m1-2;i = i+2){
     w1[i] = (1.0/6.0)*(z1[i+2] - z1[i-2]);
   }
   
   diff = inf2- inf1;
   reversalprob = 0.0;
   for(i = 1; i <= m1; i++){
     mu = (sqrt(inf2)*bdecision[k] -z1[i]*sqrt(inf1) - theta*(inf2-inf1))/sqrt(inf2-inf1);
     reversalprob += w1[i]*(1.0/sqrt(twopi))*exp(-0.5*pow(z1[i] - theta*sqrt(inf1),2))*g01eaf_(&tail, &mu, &ifail);
     if(ifail != 0){
       printf("there has been an error in nag g01eaf in reversal2.c \n");
     }
   }  
  }
  else{
    for(s=1; s <= k-1; s++){ 
      index1=0;
      index2=0;
      mesh=6*r-1;
      mesh1=0;
      m2=0;
      inf2 = observed[s]/pow(2*sigma,2);
      
      /* Creating mesh efficient for integrating marginal density of
       * Zs ~ N(theta*sqrt(infs), 1.0) */
      
      for(i=1;i <= mesh;i++){
	if(i<= (r-1)){
	  x[i] =(theta)*sqrt(inf2) -3.0 - 4.0*log(r/i);
	}
	else if(i >= r && i <= 5*r){
	  x[i] =(theta)*sqrt(inf2) -3.0 +3.0*(i-r)/(2.0*r);
	}
	else{
	  x[i]= (theta)*sqrt(inf2) + 3.0 + 4.0*log(r/(6.0*r - i));
       }
      }
      
     /* To integrate over the range (bdlower[s], bdupper[s]) cut the grid down. */

      if(bdupper[s] >=x[mesh] && (bdlower[s] > x[1] && bdlower[s] < x[mesh])){
       index1 = mesh;
       for(i=1; i <= mesh; i++){
	 if(x[i] < bdlower[s]){
	   index2 = i;
	 }
	 if(x[i] < bdlower[s] && i< mesh){
	   x[i] = bdlower[s];
	 }
       }
     }
      else if( bdlower[s] <= x[1] && (bdupper[s] < x[mesh] && bdupper[s] > x[1])){
	index2 =1;
	for(i = mesh; i>=1; i--){
	  if( x[i] >= bdupper[s]){
	    index1 = i;
	  }
	  if( x[i] > bdupper[s] && i > 1){
	    x[i] = bdupper[s];
	  }
	}
      }
      else if( bdlower[s] <=x[1] && bdupper[s] >= x[mesh]){
	index1=mesh;
	index2 = 1;
      }
      else if( (bdlower[s]<= x[1] && bdupper[s] <= x[1]) || (bdlower[s] >= x[mesh] && bdupper[s] >= x[mesh])){
	index1 = 2;
	index2 = 1;
	x[1] = bdlower[s];
	x[2] = bdupper[s];
      }
      else{
	for(i = mesh; i>=1; i--){
	  if( x[i] >= bdupper[s]){
	    index1 = i;
	  }
	  if( x[i] > bdupper[s] && i > 1){
	    x[i] = bdupper[s];
	  }
	}
	
	for(i=1; i <= mesh; i++){
	  if(x[i] < bdlower[s]){
	    index2 = i;
	  }
	  if(x[i] < bdlower[s] && i< mesh){
	    x[i] = bdlower[s];
	  }
	}
      }
      
      mesh1 = index1 - index2 + 1;
      /* Mapping the required original mesh points into new grid called x2 */
      for(i=1; i<=mesh1; i++){
	xgrid[i] = x[i+ index2 - 1];
      }
      m2 = 2*mesh1-1;
      
      /* Calculate the mid points */
      for(i=1;i <= m2; i=i+2){
	j=(i+1)/2;
	z2[i] = xgrid[j];
      }
      for(i=2; i<= m2-1;i=i+2){
	z2[i] = (z2[i-1]+z2[i+1])/2.0;
      }
      
      /* Calculate the simpsons rule weightings */
      w2[1] = (1.0/6.0)*(z2[3]-z2[1]);
      w2[m2] = (1.0/6.0)*(z2[m2]-z2[m2-2]);
      
      for(i=2; i<=m2-1; i=i+2){
	w2[i] = (4.0/6.0)*(z2[i+1]-z2[i-1]);
      }
      for(i=3;i<=m2-2;i=i+2){
	w2[i] = (1.0/6.0)*(z2[i+2]-z2[i-2]);
      }

      diff = inf2-inf1;   
      /* h2 stores the vector hk and h1 stores the vector h(k-1) */
      /* z2 are a grid of points of zk values and z1 the mesh for z(k-1). */
      for(i2=1; i2 <=m2; i2=i2+1){
	h2[i2] =0.0; 
	for(i1 = 1; i1 <= m1; i1++){
	  h2[i2] += h1[i1]*w2[i2]*sqrt(inf2/(twopi*diff))*exp((-0.5/diff)*pow(z2[i2]*sqrt(inf2)-z1[i1]*sqrt(inf1)-theta*diff,2));
	}
      }
      /* overwriting h(k-1) with h(k) and also z(k-1) with zk
       * ready for the next iteration of the program. */
      for(i=1;i<=m2;i++){
	h1[i] = h2[i];
	z1[i]= z2[i];
      }
      m1 = m2;
      inf1=inf2;
    }
    
    /* We're at interim analysis k.*/
    inf2 = observed[k]/pow(2*sigma,2);
    mesh = 6*r-1;
    for(i=1;i <= mesh;i++){
      if(i<= (r-1)){
	x[i] =(theta)*sqrt(inf2) -3.0 - 4.0*log(r/i);
      }
      else if(i >= r && i <= 5*r){
	x[i] =(theta)*sqrt(inf2) -3.0 +3.0*(i-r)/(2.0*r);
      }
      else{
	x[i]= (theta)*sqrt(inf2) + 3.0 + 4.0*log(r/(6.0*r - i));
      }
    }
    /* Create a mesh for integrating Zk from (bdupper[k], +infty).*/
    if(bdupper[k] >= x[mesh]){
      printf("Mesh for Zk in reversal2.c with theta=%lf does not cover u_k \n", theta);
      printf("Run program again with increased mesh parameter r \n");
      x[mesh-1] = bdupper[k];
      x[mesh] = bdupper[k]+0.1;
      index1 = mesh-1;
    }
    else if(bdupper[k] <= x[1]){
      index1 = 1;
    }
    else{
      for(i =1;i<= mesh;i++){
	if(x[i] <= bdupper[k]){
	  index1 = i; 
	}
	if(x[i] <= bdupper[k] && i < mesh){
	  x[i] = bdupper[k];
	}
      }
    }
    
   mesh1 = mesh - index1 +1;
   for(i=1;i<= mesh1;i++){
     xgrid[i] = x[i + index1 -1];
   }
   m2 = 2*mesh1 -1;
   
   for(i=1;i <= m2; i=i+2){
     j = (i+1)/2;
     z2[i] = xgrid[j];
   }   
   for(i=2; i <= m2-1; i= i+2){
     z2[i] = (z2[i-1] + z2[i+1])/2.0;
   }

   w2[1] = (1.0/6.0)*(z2[3] - z2[1]);  
   w2[m2] = (1.0/6.0)*(z2[m2] - z2[m2-2]);
   
   for(i=2;i <= m2-1;i=i+2){
     w2[i] = (4.0/6.0)*(z2[i+1] - z2[i-1]);
   }
   for(i=3;i <= m2-2;i = i+2){
     w2[i] = (1.0/6.0)*(z2[i+2] - z2[i-2]);
   }
  
   diff = inf2 - inf1;
   
   for(i2=1; i2 <=m2; i2=i2+1){
     h2[i2] =0.0; 
     for(i1 = 1; i1 <= m1; i1++){
       h2[i2] += h1[i1]*w2[i2]*sqrt(inf2/(twopi*diff))*exp(-(0.5/diff)*pow(z2[i2]*sqrt(inf2)- z1[i1]*sqrt(inf1)-theta*diff,2));
     }
   }

   /* At decision analysis k, calculate P(l1<Z1<u1,..., l(k-1)<Z(k-1)<u(k-1), Zk>uk, Z'k<ck; theta=0).*/
   inf1 = inf2;
   inf2 = recruited[k]/pow(2*sigma,2);
   diff = inf2-inf1;
   
   reversalprob = 0.0;
   for(i = 1; i <= m2; i++){
     mu = (sqrt(inf2)*bdecision[k] - z2[i]*sqrt(inf1) - theta*diff)/ sqrt(diff);
     reversalprob += h2[i]*g01eaf_(&tail, &mu, &ifail);
     if(ifail != 0){
       printf("there has been an error in nag routine g01eaf in reversal2.c \n");
     }
   }    
  }
 
 return reversalprob;
}
