/* including the external header files. */
#include<stdio.h> 
#include<math.h>
#include<stdlib.h>

/* Numerical search and integration parameters.
 * r indexes the fineness of the numerical integration meshes: if r is increased,
 * n1, n2, and n3 will also need to be increased (see Jennison & Turnbull, 2000, Chapter 19.2 for details).*/

/* If interim analyses are very closely spaced in information (e.g. if na is large),
 * then a finer mesh should be used with r=64.*/

#define r 16.0
#define n1 201
#define n2 401
#define n3 801
#define tol 0.00001

/* External nag F77 routines called. */
extern double g01faf_ ();
extern double g01eaf_ ();

 
/* Desired type I and type II error probabilities. */
#define type1 0.025
#define type2 0.10

/* defining required constants.
 * na    = maximum number of stages (K) in the trial
 * delta = alternative at which power is specified
 * sigma = SD of observed responses.*/

#define twopi 6.283185307
#define na 5
#define nastar na +1
#define delta 1.0
#define sigma sqrt(1.0)

double findconstants(double *bdupper, double *bdlower, double *bdecision, double R,double nfix, double ratio, double *observed, double *recruited, double rho, char spendtype);

double type1error(double *observed, int k, double *bdupper,double *bdlower, double theta, double c);

double type2error(double *expect, int k, double *bdupper,double *bdlower, double theta, double c);

void bisection(double *bdupper, double *bdlower, double spend1, double spend2, int k, double *observed);

double inflate(double *bdupper,double *bdlower,double *bdecision, double rho, double nfix,double ratio,double *observed,double *recruited, char spendtype);

void symmetry(double *bdecision, double *bdupper, double *bdlower, double *observed, double *recruited, int k);

double reversal2(double *bdecision, double *bdupper, double *bdlower, double *observed, double *recruited, int k, double theta);

double reversal1(double *bdecision, double *bdupper, double *bdlower, double *observed, double *recruited, int k, double theta);

double type1errorstar(int k, double *bdupper,double *bdlower, double theta, double *recruited, double *observed, double *bdecision);

double type2errorstar(int k, double *bdupper,double *bdlower, double theta, double *recruited, double *observed, double *bdecision);

double min(double a, double b);

void expectation(double *observed, double *recruited, double *bdupper, double *bdlower, double *bdecision, double *expect);
