#include "header.h"

/* Function uses bisection search routine to find needed stopping boundaries at interim analysis k. */

void bisection(double *bdupper, double *bdlower, double spend1, double spend2, int k, double *observed){
  int i=0;
  double y=0.0, z=0.0, fy=0.0, fz=0.0, grad=0.0, mp=0.0, fmp=0.0;

  /* *******************************************************************************
   * bdupper   = upper boundaries of the stopping rule at interim analyses
   * bdlower   = lower boundaries of the stopping at interim analyses
   * spend1    = type I error probability under theta=0 to be spent at stage k
   * spend2    = type II error probability under theta=delta to be spent at stage k
   * k         = current stage of the GST
   * observed  = number of observed responses at interim analyses  
   *********************************************************************************/

  /* Calculate upper boundary.*/
  y = -20.0;
  z = 20.0;
  fy = spend1 - type1error(observed, k, bdupper, bdlower,0.0, y);
  fz = spend1 - type1error(observed, k, bdupper, bdlower, 0.0, z);

  if(fy >= 0){
    bdupper[k] = -20;
  }
  else{
    while( (z-y) >tol){
      mp = (y+z)/2.0;
      fmp = spend1 - type1error(observed, k, bdupper, bdlower, 0.0, mp);
      if(fmp*fy >0){
	y=mp;
	fy = fmp;
      }
      else{
	z=mp;
      }  
    } 
    
    /* linear interpolation to find a more accurate estimate of bdupper[k] */
    fy = spend1 - type1error(observed, k, bdupper, bdlower, 0.0, y); 
    fz = spend1 - type1error(observed, k, bdupper, bdlower, 0.0, z);
    grad = (fz - fy)/(z-y);
    bdupper[k] = y + (-fy/grad);
  }

  /* Calculate lower boundary.*/
  y = -20.0;
  z = 20.0;
  fy = type2error(observed, k, bdupper, bdlower, delta, y) - spend2;
  fz = type2error(observed, k, bdupper, bdlower, delta, z) - spend2;
 
 
  if(fz <= 0){
    bdlower[k] = 20;
  }
  else{
    while( (z-y) >tol){
      mp = (y+z)/2.0;
      fmp = type2error(observed, k, bdupper, bdlower, delta, mp) - spend2;
      if(fmp*fy >0){
	y=mp;
	fy = fmp;
      }
      else{
	z=mp;
      }  
    } 
    
    /* now want linear interpolation to find a more accurate estimate of bdlower[k] */
    fy = type2error(observed, k, bdupper, bdlower, delta, y) - spend2; 
    fz = type2error(observed, k, bdupper, bdlower, delta, z) - spend2;
    grad = (fz - fy)/(z-y);
    bdlower[k] = y + (-fy/grad);
  }
 
}
