close all; clear all;

% defining the signal
T = 100;
Fs = 20;
N = T * Fs;
t = linspace(0 , T, N);
x = randn(1, N);

% defining the wavelet parameters
wavelet = 'lognorm';
fmin = 5 / T;
fmax = Fs / 2;
p = 1;
nv = 24;
f0 = 1;
cutEdges = true;
logBase = exp(1);

% defining the time window in sec for bispectrum
twin = [20 80];
%%
% wavelet transform
[wtx, freq, wavPar] = wav(x, Fs, wavelet, f0, fmin, fmax, nv, p, cutEdges, logBase);

figure; 
pc = pcolor(t, freq, abs(wtx)); 
pc.LineStyle = 'none';
set(gca, 'YScale', 'log')
% wavelet bispectrum
[Bisp, norms, freqs] = BispectrumTemp(x, x, x, Fs, wavelet, f0, fmin, fmax, nv, p, cutEdges, logBase, twin);
% multiplying by normalisation 1/D
bisp = Bisp .* norms;

figure; 
pc = pcolor(freq, freq, abs(bisp)); 
pc.LineStyle = 'none';
set(gca, 'XScale', 'log', 'YScale', 'log');
axis square;
