#include "header.h"

/* ******************************************************************************************************
 * Evaluate objective functions for the optimal Delayed Response GST boundaries:
 *
 * obj == 1 evaluates F1 = E(N; theta= delta/2)
 * obj == 2 evaluates F2 = 0.5*( E(N; theta=delta) + E(N; theta=0) )
 * obj == 3 evaluates F3 = 0.5*(E(N; theta = -delta/2) + E(N; theta = 3*delta/2))
 * obj == 4 evaluates F4 which is average E(N; theta) over a N(delta/2, (delta/2)^2) density for theta.
 * 
 * ******************************************************************************************************/

void expectation(double *observed, double *recruited, double *bdupper, double *bdlower, double *bdecision, double *expect){

  double temp1 =0.0, temp2 = 0.0,temp3=0, x[n1]={0}, xgrid[n2]={0}, w1[n2]={0};
  int k=0, i=0, g2=0, grid=0, j=0, obj;

  /* *******************************************************************************
   * observed  = observed number of responses at interim analyses
   * recruited = number of subjects recruited at interim analyses
   * bdupper   = upper boundaries of the stopping rule at interim analyses
   * bdlower   = lower boundaries of the stopping at interim analyses
   * bdecision = critical values used at decision analyses
   * expect    = values of objective functions F1, ..., F4   
   * ********************************************************************************/


  for(obj=1; obj <= 4; obj++){
    if(obj ==1){
      /* evaluating objective function F1 = E(N|theta = delta/2). */
      temp1 =0.0;
      temp2 = 0.0;
      for(k=1;k<= (na-1); k++){
	temp3 = type1error(observed, k,bdupper, bdlower, delta/2.0, bdupper[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
	
	temp3 = type2error(observed, k,bdupper, bdlower, delta/2.0, bdlower[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
      }
      expect[obj] = temp1 + (1- temp2)*observed[na]; 
    }
    else if(obj ==2){
      /* evaluating objective function F2 = (1/2)*(E(N|theta = delta) + E(N|theta=0)). */
      temp1 = 0.0;
      temp2 = 0.0;
      for(k=1;k<= (na-1);k++){
	temp3 = type1error(observed, k,bdupper, bdlower, delta, bdupper[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
	
	temp3 = type2error(observed, k,bdupper, bdlower, delta, bdlower[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
      }
      expect[obj] = temp1 + (1- temp2)*observed[na]; 
      
      temp1 =0.0;
      temp2 =0.0;
      for(k=1;k<= (na-1);k++){
	temp3 = type1error(observed, k,bdupper, bdlower, 0.0, bdupper[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
	
	temp3 = type2error(observed, k,bdupper, bdlower, 0.0, bdlower[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
      }
      
      expect[obj] += temp1 + (1- temp2)*observed[na];
      expect[obj] = (0.5)*expect[obj];
    }
    else if(obj ==3){
      temp1=0;
      temp2=0;
      /* evaluating objective function F3 = (1/2)*(E(N|theta = -delta/2) + E(N|theta = 3*delta/2)) . */
      for(k=1;k<= (na-1);k++){
	temp3  = type1error(observed, k,bdupper, bdlower, -delta/2.0, bdupper[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
	
	temp3 = type2error(observed, k,bdupper, bdlower, -delta/2, bdlower[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
      }
      expect[obj] = temp1 + (1- temp2)*observed[na]; 
      temp1=0.0;
      temp2=0.0;
      for(k=1;k<= (na-1);k++){
	temp3 = type1error(observed, k,bdupper, bdlower, 3*delta/2, bdupper[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
	
	temp3 = type2error(observed, k,bdupper, bdlower, 3*delta/2, bdlower[k]);
	temp1 += temp3*recruited[k];
	temp2 += temp3;
      }
      expect[obj] += temp1 + (1- temp2)*observed[na]; 
      expect[obj] = 0.5*expect[obj];
    }
    else{	  
      /* evaluating F4 so setting up a mesh for the marginal density of theta~N((delta/2), (delta/2)**2). */
      grid = 6.0*(16.0) - 1;
      
      for(i=1;i<=grid;i++){
	if(i<= (r-1)){
	  x[i] =(delta/2.0)+  (delta/2.0)*(-3.0 - 4.0*log(r/i));
	}
	else if(i>= r && i<= 5*r){
	  x[i] = (delta/2.0) + (delta/2.0)*( -3.0 +3.0*(i- r)/(2.0*r));
	}
	else{
	  x[i]= (delta/2.0) + (delta/2.0)*(3.0 + 4.0*log(r/(6.0*r - i)));
	}
      }       
      
      g2 = 2*grid - 1; 
      
      /*now weve cut down the grid, we calculate the mid points and put all the points together in a vector
	called xgrid */
      for(i=1; i <= g2; i=i+2){
	j = (i+1)/2;
	xgrid[i] = x[j];
      }
      for(i=2; i<= g2-1;i=i+2){
	xgrid[i] = (xgrid[i-1] + xgrid[i+1])/2.0;
      }
      


      w1[1] = (1.0/6.0)*(xgrid[3]-xgrid[1]);
      w1[g2] = (1.0/6.0)*(xgrid[g2]-xgrid[g2-2]);
      for(i=3; i<=g2-2;i=i+2){
	w1[i] = (1.0/6.0)*(xgrid[i+2]-xgrid[i-2]);
      }
      for(i=2; i<= g2-1;i=i+2){
	w1[i]= (4.0/6.0)*(xgrid[i+1]-xgrid[i-1]);
      }
      
      
      expect[obj]=0.0;
      for(i=1;i<=g2;i++){  
	temp1 = 0.0;
	temp2 =0.0;
	for(k=1;k <= (na-1);k++){
	  temp3 = type1error(observed, k,bdupper, bdlower, xgrid[i], bdupper[k]);
	  temp1 += temp3*recruited[k];
	  temp2 += temp3;
	  
	  temp3 = type2error(observed, k,bdupper, bdlower, xgrid[i], bdlower[k]);
	  temp1 += temp3*recruited[k];
	  temp2 += temp3;
	}
	temp2 = temp1 + (1- temp2)*observed[na];

	expect[obj] += w1[i]*(1.0/sqrt(twopi*pow(delta/2.0,2)))*exp(-(0.5/pow(delta/2.0,2))*pow(xgrid[i] - (delta/2.0),2))*(temp2);
      }   
      
    }
  }
  
}
